/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PoultrygeistEffect
extends OneShotEffect {
    PoultrygeistEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "roll a six-sided die. If you roll a 1, sacrifice {this}. Otherwise, put a +1/+1 counter on {this}";
    }

    private PoultrygeistEffect(PoultrygeistEffect ability) {
        super((OneShotEffect)ability);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int result = controller.rollDice(this.outcome, source, game, 6);
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent != null) {
                if (result == 1) {
                    return permanent.sacrifice(source, game);
                }
                return new AddCountersSourceEffect(CounterType.P1P1.createInstance()).apply(game, source);
            }
        }
        return false;
    }

    public PoultrygeistEffect copy() {
        return new PoultrygeistEffect(this);
    }
}

