/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PowerLeakEffect
extends OneShotEffect {
    PowerLeakEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player may pay any amount of mana. {this} deals 2 damage to that player. Prevent X of that damage, where X is the amount of mana that player paid this way";
    }

    private PowerLeakEffect(PowerLeakEffect effect) {
        super((OneShotEffect)effect);
    }

    public PowerLeakEffect copy() {
        return new PowerLeakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        String message = "Pay {X} to prevent X damage from " + permanent.getLogName() + "?";
        int xValue = 0;
        if (player.chooseUse(Outcome.Neutral, message, source, game)) {
            xValue = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to prevent damage)", game, source, true);
            cost.add((Object)new GenericManaCost(xValue));
            if (cost.pay(source, game, source, player.getId(), false, null)) {
                game.informPlayers(player.getLogName() + " paid {" + xValue + "} for " + permanent.getLogName());
            } else {
                game.informPlayers(player.getLogName() + " didn't pay {X} for " + permanent.getLogName());
            }
        } else {
            game.informPlayers(player.getLogName() + " didn't pay {X} for " + permanent.getLogName());
        }
        PreventDamageByTargetEffect effect = new PreventDamageByTargetEffect(Duration.OneUse, xValue, false);
        if (xValue != 0 && cost.isPaid()) {
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        player.damage(2, source.getSourceId(), source, game);
        effect.discard();
        return true;
    }
}

