/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import mage.MageObject;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.ManaUtil;

class PowerSinkCounterUnlessPaysEffect
extends OneShotEffect {
    PowerSinkCounterUnlessPaysEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell unless its controller pays {X}. If that player doesn't, they tap all lands with mana abilities they control and lose all unspent mana";
    }

    private PowerSinkCounterUnlessPaysEffect(PowerSinkCounterUnlessPaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public PowerSinkCounterUnlessPaysEffect copy() {
        return new PowerSinkCounterUnlessPaysEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Player player = game.getPlayer(spell.getControllerId());
            Player controller = game.getPlayer(source.getControllerId());
            MageObject sourceObject = game.getObject(source);
            if (player != null && controller != null && sourceObject != null) {
                int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
                if (amount > 0) {
                    ManaCost cost = ManaUtil.createManaCost((int)amount, (boolean)true);
                    if (player.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + " to prevent?", source, game) && cost.pay(source, game, source, player.getId(), false)) {
                        game.informPlayers(sourceObject.getName() + ": additional cost was paid");
                        return true;
                    }
                    game.informPlayers(sourceObject.getName() + ": additional cost wasn't paid - countering " + spell.getName());
                    game.getStack().counter(source.getFirstTarget(), source, game);
                    List lands = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterLandPermanent(), player.getId(), game);
                    block0: for (Permanent land : lands) {
                        Abilities landAbilities = land.getAbilities();
                        for (Ability ability : landAbilities) {
                            if (!ability.isManaActivatedAbility()) continue;
                            land.tap(source, game);
                            continue block0;
                        }
                    }
                    player.getManaPool().emptyPool(game);
                }
                return true;
            }
        }
        return false;
    }
}

