/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTappedCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PreacherEffect
extends OneShotEffect {
    PreacherEffect() {
        super(Outcome.GainControl);
        this.staticText = "Gain control of target creature of an opponent's choice that they control for as long as {this} remains tapped";
    }

    private PreacherEffect(PreacherEffect effect) {
        super((OneShotEffect)effect);
    }

    public PreacherEffect copy() {
        return new PreacherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && sourcePermanent != null && targetPermanent != null) {
            SourceTappedCondition sourceTappedCondition = SourceTappedCondition.TAPPED;
            ConditionalContinuousEffect effect = new ConditionalContinuousEffect((ContinuousEffect)new GainControlTargetEffect(Duration.Custom), (Condition)sourceTappedCondition, "Gain control of target creature of an opponent's choice that they control for as long as {this} remains tapped");
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

