/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.p.PrecursorGolemCopySpellEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.util.TargetAddress;

class PrecursorGolemCopyTriggeredAbility
extends TriggeredAbilityImpl {
    PrecursorGolemCopyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PrecursorGolemCopySpellEffect(), false);
    }

    private PrecursorGolemCopyTriggeredAbility(PrecursorGolemCopyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PrecursorGolemCopyTriggeredAbility copy() {
        return new PrecursorGolemCopyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        UUID targetGolem = null;
        for (TargetAddress addr : TargetAddress.walk((Card)spell)) {
            Target targetInstance = addr.getTarget(spell);
            for (UUID target : targetInstance.getTargets()) {
                Permanent permanent = game.getPermanent(target);
                if (permanent == null || !permanent.hasSubtype(SubType.GOLEM, game)) {
                    return false;
                }
                if (targetGolem == null) {
                    targetGolem = target;
                    continue;
                }
                if (targetGolem.equals(target)) continue;
                return false;
            }
        }
        if (targetGolem == null) {
            return false;
        }
        this.getEffects().setValue("triggeringSpell", (Object)spell);
        this.getEffects().setValue("targetedGolem", targetGolem);
        return true;
    }

    public String getRule() {
        return "Whenever a player casts an instant or sorcery spell that targets only a single Golem, that player copies that spell for each other Golem that spell could target. Each copy targets a different one of those Golems.";
    }
}

