/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PredictEffect
extends OneShotEffect {
    PredictEffect() {
        super(Outcome.DrawCard);
        this.staticText = ", then target player mills a card. If a card with the chosen name was milled this way, you draw two cards. Otherwise, you draw a card.";
    }

    private PredictEffect(PredictEffect effect) {
        super((OneShotEffect)effect);
    }

    public PredictEffect copy() {
        return new PredictEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (controller == null || targetPlayer == null || cardName == null || cardName.isEmpty()) {
            return false;
        }
        int toDraw = 1;
        for (Card card : targetPlayer.millCards(1, source, game).getCards(game)) {
            if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
            toDraw = 2;
            break;
        }
        controller.drawCards(toDraw, source, game);
        return true;
    }
}

