/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PrimalInstictEffect
extends OneShotEffect {
    PrimalInstictEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Put a +1/+1 counter on target creature, then double the number of +1/+1 counters on that creature.";
    }

    private PrimalInstictEffect(PrimalInstictEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (target = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            target.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            int addCounterCount = target.getCounters(game).getCount(CounterType.P1P1);
            game.informPlayers("Counters " + addCounterCount);
            target.addCounters(CounterType.P1P1.createInstance(addCounterCount), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }

    public PrimalInstictEffect copy() {
        return new PrimalInstictEffect(this);
    }
}

