/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class PrimalPrayersCastEffect
extends ContinuousEffectImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature cards with mana value 3 or less");
    private final AlternativeCostSourceAbility alternativeCastingCostAbility;

    public PrimalPrayersCastEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "you may cast creature cards with mana value 3 or less by paying {E} rather than paying their mana costs";
        this.alternativeCastingCostAbility = new AlternativeCostSourceAbility((Cost)new PayEnergyCost(1), (Condition)SourceIsSpellCondition.instance, null, (FilterCard)filter, true);
        this.alternativeCastingCostAbility.setIdentifier(MageIdentifier.PrimalPrayersAlternateCast);
    }

    private PrimalPrayersCastEffect(PrimalPrayersCastEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.alternativeCastingCostAbility = effect.alternativeCastingCostAbility.copy();
    }

    public PrimalPrayersCastEffect copy() {
        return new PrimalPrayersCastEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
        controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 3));
    }
}

