/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PrimordialOozeEffect
extends OneShotEffect {
    PrimordialOozeEffect() {
        super(Outcome.Detriment);
        this.staticText = "Then you may pay {X}, where X is the number of +1/+1 counters on it. If you don't, tap {this} and it deals X damage to you";
    }

    private PrimordialOozeEffect(PrimordialOozeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrimordialOozeEffect copy() {
        return new PrimordialOozeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
        if (controller != null && sourceObject != null) {
            int counter = sourceObject.getCounters(game).getCount(CounterType.P1P1);
            ManaCostsImpl cost = new ManaCostsImpl("{" + counter + '}');
            if (!controller.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + " to prevent taking " + counter + " damage from " + sourceObject.getLogName() + "?", source, game) || !cost.pay(source, game, source, controller.getId(), false, null)) {
                sourceObject.tap(source, game);
                controller.damage(counter, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

