/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetControlledCreaturePermanent;

class PrishesWanderingsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("basic land card or Town card");

    PrishesWanderingsEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a basic land card or Town card, put it onto the battlefield tapped, then shuffle. When you search your library this way, put a +1/+1 counter on target creature you control";
    }

    private PrishesWanderingsEffect(PrishesWanderingsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrishesWanderingsEffect copy() {
        return new PrishesWanderingsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        if (player.searchLibrary(target, source, game)) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false);
            ability.addTarget((Target)new TargetControlledCreaturePermanent());
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        if ((card = player.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)Predicates.and((Predicate)SuperType.BASIC.getPredicate(), (Predicate)CardType.LAND.getPredicate()), (Predicate)SubType.TOWN.getPredicate()));
    }
}

