/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PrizePigEffect
extends OneShotEffect {
    PrizePigEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if there are three or more ribbon counters on {this}, remove those counters and untap it";
    }

    private PrizePigEffect(PrizePigEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrizePigEffect copy() {
        return new PrizePigEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        int count = permanent.getCounters(game).getCount(CounterType.RIBBON);
        if (count >= 3) {
            permanent.removeCounters(CounterType.RIBBON.createInstance(count), source, game);
            permanent.untap(game);
        }
        return true;
    }
}

