/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.p.ProfessorHojoWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.util.CardUtil;

class ProfessorHojoEffect
extends CostModificationEffectImpl {
    ProfessorHojoEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the first activated ability you activate during your turn that targets a creature you control costs {2} less to activate";
    }

    private ProfessorHojoEffect(ProfessorHojoEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public ProfessorHojoEffect copy() {
        return new ProfessorHojoEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Set targets = game.inCheckPlayableState() ? CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game) : CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
        if (!game.isActivePlayer(source.getControllerId())) return false;
        if (!abilityToModify.isControlledBy(source.getControllerId())) return false;
        if (!abilityToModify.isActivatedAbility()) return false;
        if (ProfessorHojoWatcher.checkPlayer(game, source)) return false;
        if (!targets.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isCreature(game)).map(Controllable::getControllerId).anyMatch(arg_0 -> ((Ability)source).isControlledBy(arg_0))) return false;
        return true;
    }
}

