/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.p.PromiseOfLoyaltyAttackEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PromiseOfLoyaltyEffect
extends OneShotEffect {
    PromiseOfLoyaltyEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player puts a vow counter on a creature they control and sacrifices the rest. Each of those creatures can't attack you or planeswalkers you control for as long as it has a vow counter on it";
    }

    private PromiseOfLoyaltyEffect(PromiseOfLoyaltyEffect effect) {
        super((OneShotEffect)effect);
    }

    public PromiseOfLoyaltyEffect copy() {
        return new PromiseOfLoyaltyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, playerId, source, game) < 1) continue;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanents.add(permanent);
            permanent.addCounters(CounterType.VOW.createInstance(), playerId, source, game);
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getSourceId(), game)) {
            if (permanent == null) continue;
            if (permanents.contains(permanent)) {
                game.addEffect(new PromiseOfLoyaltyAttackEffect().setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
                continue;
            }
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

