/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.DemonFlyingToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class PromiseOfPowerEffect
extends OneShotEffect {
    PromiseOfPowerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Create an X/X black Demon creature token with flying, where X is the number of cards in your hand";
    }

    private PromiseOfPowerEffect(PromiseOfPowerEffect ability) {
        super((OneShotEffect)ability);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return new CreateTokenEffect((Token)new DemonFlyingToken(controller.getHand().size())).apply(game, source);
        }
        return false;
    }

    public PromiseOfPowerEffect copy() {
        return new PromiseOfPowerEffect(this);
    }
}

