/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ProtectionRacketEffect
extends OneShotEffect {
    ProtectionRacketEffect() {
        super(Outcome.Benefit);
        this.staticText = "repeat the following process for each opponent in turn order. Reveal the top card of your library. That player may pay life equal to that card's mana value. If they do, exile that card. Otherwise, put it into your hand";
    }

    private ProtectionRacketEffect(ProtectionRacketEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProtectionRacketEffect copy() {
        return new ProtectionRacketEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            Card card = controller.getLibrary().getFromTop(game);
            if (player == null || card == null) continue;
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            int mv = card.getManaValue();
            PayLifeCost cost = new PayLifeCost(mv);
            if (cost.canPay(source, source, playerId, game) && player.chooseUse(Outcome.Detriment, "Pay " + mv + " life to exile " + card.getName() + '?', source, game)) {
                cost.pay(source, game, source, playerId, true);
                controller.moveCards(card, Zone.EXILED, source, game);
                continue;
            }
            controller.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

