/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetSource;
import mage.util.CardUtil;

class ProtectiveSphereEffect
extends PreventionEffectImpl {
    private final TargetSource target;
    private static Mana manaUsed;
    private static List<ObjectColor> colorsOfChosenSource;

    public ProtectiveSphereEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "Prevent all damage that would be dealt to you this turn by a source of your choice that shares a color with the mana spent on this activation cost.";
        this.target = new TargetSource();
    }

    private ProtectiveSphereEffect(ProtectiveSphereEffect effect) {
        super((PreventionEffectImpl)effect);
        this.target = effect.target.copy();
    }

    public ProtectiveSphereEffect copy() {
        return new ProtectiveSphereEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.target.withNotTarget(true);
        this.target.setRequired(false);
        Player controller = game.getPlayer(source.getControllerId());
        Permanent protectiveSphere = game.getPermanent(source.getSourceId());
        if (controller != null && protectiveSphere != null) {
            game.getState().setValue("ProtectiveSphere" + source.getSourceId().toString(), (Object)source.getManaCostsToPay().getUsedManaToPay());
            protectiveSphere.addInfo("MANA USED", CardUtil.addToolTipMarkTags((String)("Last mana used for protective ability: " + source.getManaCostsToPay().getUsedManaToPay())), game);
        }
        this.target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        manaUsed = (Mana)game.getState().getValue("ProtectiveSphere" + source.getSourceId().toString());
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId()) && event.getSourceId().equals(this.target.getFirstTarget()) && (colorsOfChosenSource = game.getObject(this.target.getFirstTarget()).getColor(game).getColors()).stream().anyMatch(c -> manaUsed.getColor(c.getOneColoredManaSymbol()) > 0);
    }

    static {
        colorsOfChosenSource = new ArrayList<ObjectColor>();
    }
}

