/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class PsychicBattleEffect
extends OneShotEffect {
    PsychicBattleEffect() {
        super(Outcome.Benefit);
    }

    private PsychicBattleEffect(PsychicBattleEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicBattleEffect copy() {
        return new PsychicBattleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            HashMap<Player, Integer> manacostMap = new HashMap<Player, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.getLibrary().hasCards()) continue;
                Card card = player.getLibrary().getFromTop(game);
                player.revealCards(sourceObject.getIdName() + " (" + player.getName() + ')', (Cards)new CardsImpl(card), game);
                manacostMap.put(player, card.getManaValue());
            }
            Player highestCostPlayer = null;
            int maxValue = (Integer)Collections.max(manacostMap.values());
            boolean tie = false;
            for (Map.Entry entry : manacostMap.entrySet()) {
                if ((Integer)entry.getValue() != maxValue) continue;
                if (highestCostPlayer != null) {
                    tie = true;
                    break;
                }
                highestCostPlayer = (Player)entry.getKey();
            }
            if (highestCostPlayer != null && !tie) {
                StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
                if (stackObject != null) {
                    stackObject.setTargetChanged(true);
                    stackObject.chooseNewTargets(game, highestCostPlayer.getId(), false, false, null);
                }
                return true;
            }
            return tie;
        }
        return false;
    }
}

