/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.p.PsychicIntrusionCastFromExileEffect;
import mage.cards.p.PsychicIntrusionSpendAnyManaEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PsychicIntrusionExileEffect
extends OneShotEffect {
    private static final FilterNonlandCard filter = new FilterNonlandCard();

    public PsychicIntrusionExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from that player's graveyard or hand and exile it. You may cast that card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast that spell";
    }

    private PsychicIntrusionExileEffect(PsychicIntrusionExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicIntrusionExileEffect copy() {
        return new PsychicIntrusionExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (opponent != null && sourceObject != null) {
            opponent.revealCards(sourceObject.getName(), opponent.getHand(), game);
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                TargetCard target;
                int cardsGraveyard = opponent.getGraveyard().count((FilterCard)filter, game);
                int cardsHand = opponent.getHand().count((FilterCard)filter, game);
                boolean fromHand = false;
                if (cardsGraveyard > 0 && cardsHand > 0) {
                    if (controller.chooseUse(Outcome.Detriment, "Exile card from opponents Hand?", source, game)) {
                        fromHand = true;
                    }
                } else if (cardsHand > 0) {
                    fromHand = true;
                }
                Card card = null;
                if (cardsHand > 0 && fromHand) {
                    target = new TargetCard(Zone.HAND, (FilterCard)filter);
                    if (controller.choose(Outcome.Benefit, opponent.getHand(), target, source, game)) {
                        card = opponent.getHand().get(target.getFirstTarget(), game);
                    }
                }
                if (cardsGraveyard > 0 && !fromHand) {
                    target = new TargetCard(Zone.GRAVEYARD, (FilterCard)filter);
                    if (controller.choose(Outcome.Benefit, (Cards)opponent.getGraveyard(), target, source, game)) {
                        card = opponent.getGraveyard().get(target.getFirstTarget(), game);
                    }
                }
                if (card != null) {
                    UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
                    controller.moveCardToExileWithInfo(card, exileId, sourceObject.getIdName(), source, game, fromHand ? Zone.HAND : Zone.GRAVEYARD, true);
                    AsThoughEffectImpl effect = new PsychicIntrusionCastFromExileEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                    game.addEffect((ContinuousEffect)effect, source);
                    effect = new PsychicIntrusionSpendAnyManaEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                    game.addEffect((ContinuousEffect)effect, source);
                }
                return true;
            }
        }
        return false;
    }
}

