/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PsychicMiasmaEffect
extends OneShotEffect {
    PsychicMiasmaEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player discards a card. If a land card is discarded this way, return {this} to its owner's hand";
    }

    private PsychicMiasmaEffect(PsychicMiasmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            Card spellCard;
            Card discardedCard = player.discardOne(false, false, source, game);
            if (discardedCard != null && discardedCard.isLand(game) && (spellCard = game.getStack().getSpell(source.getSourceId()).getCard()) != null) {
                player.moveCards(spellCard, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    public PsychicMiasmaEffect copy() {
        return new PsychicMiasmaEffect(this);
    }
}

