/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.condition.common.SpellMasteryCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class PsychicRebuttalEffect
extends OneShotEffect {
    PsychicRebuttalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target instant or sorcery spell that targets you.<br><i>Spell mastery</i> &mdash; If there are two or more instant and/or sorcery cards in your graveyard, you may copy the spell countered this way. You may choose new targets for the copy";
    }

    private PsychicRebuttalEffect(PsychicRebuttalEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicRebuttalEffect copy() {
        return new PsychicRebuttalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            game.getStack().counter(spell.getId(), source, game);
            if (SpellMasteryCondition.instance.apply(game, source) && controller.chooseUse(Outcome.PlayForFree, "Copy " + spell.getName() + " (you may choose new targets for the copy)?", source, game)) {
                spell.createCopyOnStack(game, source, source.getControllerId(), true);
            }
            return true;
        }
        return false;
    }
}

