/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PsychicSurgeryEffect
extends OneShotEffect {
    PsychicSurgeryEffect() {
        super(Outcome.Exile);
        this.staticText = "you may look at the top two cards of that library. You may exile one of those cards. Then put the rest on top of that library in any order";
    }

    private PsychicSurgeryEffect(PsychicSurgeryEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicSurgeryEffect copy() {
        return new PsychicSurgeryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID opponentId = (UUID)this.getValue("PsychicSurgeryOpponent");
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(opponentId);
        if (controller != null && opponent != null) {
            Card card;
            TargetCard target;
            CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 2));
            controller.lookAtCards(source, null, (Cards)cards, game);
            if (!cards.isEmpty() && controller.chooseUse(Outcome.Exile, "Exile a card?", source, game) && controller.choose(Outcome.Exile, (Cards)cards, target = new TargetCard(Zone.LIBRARY, new FilterCard("card to exile")), source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                controller.moveCards(card, Zone.EXILED, source, game);
                cards.remove(card);
            }
            controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            return true;
        }
        return false;
    }
}

