/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromExileEffect;
import mage.cards.Card;
import mage.cards.p.PsychicTheftCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class PsychicTheftEffect
extends OneShotEffect {
    private static final FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();

    PsychicTheftEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player reveals their hand. You choose an instant or sorcery card from it and exile that card. You may cast that card for as long as it remains exiled. At the beginning of the next end step, if you haven't cast the card, return it to its owner's hand.";
    }

    private PsychicTheftEffect(PsychicTheftEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicTheftEffect copy() {
        return new PsychicTheftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        opponent.revealCards(CardUtil.getSourceName((Game)game, (Ability)source), opponent.getHand(), game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int cardsHand = opponent.getHand().count((FilterCard)filter, game);
        Card chosenCard = null;
        if (cardsHand > 0) {
            TargetCard target = new TargetCard(Zone.HAND, (FilterCard)filter);
            if (controller.choose(Outcome.Exile, opponent.getHand(), target, source, game)) {
                chosenCard = opponent.getHand().get(target.getFirstTarget(), game);
            }
        }
        if (chosenCard == null) {
            return false;
        }
        controller.moveCardToExileWithInfo(chosenCard, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source), source, game, Zone.HAND, true);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)chosenCard, (boolean)true, (Duration)Duration.Custom, (boolean)false);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ConditionalOneShotEffect((OneShotEffect)new ReturnFromExileEffect(Zone.HAND), (Condition)new PsychicTheftCondition(chosenCard, game), "if you haven't cast it, return it to its owner's hand.")), source);
        return true;
    }
}

