/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PsychicTransferEffect
extends OneShotEffect {
    PsychicTransferEffect() {
        super(Outcome.Neutral);
        this.staticText = "If the difference between your life total and target player's life total is 5 or less, exchange life totals with that player";
    }

    private PsychicTransferEffect(PsychicTransferEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicTransferEffect copy() {
        return new PsychicTransferEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (sourcePlayer == null || targetPlayer == null || Math.abs(sourcePlayer.getLife() - targetPlayer.getLife()) > 5) {
            return false;
        }
        sourcePlayer.exchangeLife(targetPlayer, source, game);
        return true;
    }
}

