/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class PsychomancerTriggeredAbility
extends TriggeredAbilityImpl {
    PsychomancerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1));
        this.addEffect((Effect)new GainLifeEffect(1).concatBy("and"));
        this.addTarget((Target)new TargetOpponent());
        this.setTriggerPhrase("Whenever {this} or another nontoken artifact you control is put into a graveyard from the battlefield or is put into exile from the battlefield, ");
        this.withFlavorWord("Harbinger of Despair");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private PsychomancerTriggeredAbility(PsychomancerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PsychomancerTriggeredAbility copy() {
        return new PsychomancerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED) && zEvent.getTarget() != null && (zEvent.getTargetId().equals(this.getSourceId()) || zEvent.getTarget().isArtifact(game) && !(zEvent.getTarget() instanceof PermanentToken) && zEvent.getTarget().getControllerId().equals(this.getControllerId()));
    }
}

