/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PublicExecutionEffect
extends OneShotEffect {
    PublicExecutionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each other creature that player controls gets -2/-0 until end of turn";
    }

    private PublicExecutionEffect(PublicExecutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        UUID opponent;
        Permanent target = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        if (target != null && (opponent = target.getControllerId()) != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent("each other creature that player controls");
            filter.add((Predicate)new ControllerIdPredicate(opponent));
            filter.add(Predicates.not((Predicate)new PermanentIdPredicate(target.getId())));
            BoostAllEffect effect = new BoostAllEffect(-2, 0, Duration.EndOfTurn, filter, false);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public PublicExecutionEffect copy() {
        return new PublicExecutionEffect(this);
    }
}

