/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PufferExtractEffect
extends OneShotEffect {
    PufferExtractEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control gets +X/+X until end of turn. Destroy it at the beginning of the next end step.";
    }

    private PufferExtractEffect(PufferExtractEffect effect) {
        super((OneShotEffect)effect);
    }

    public PufferExtractEffect copy() {
        return new PufferExtractEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        game.addEffect((ContinuousEffect)new BoostTargetEffect(xValue, xValue, Duration.EndOfTurn), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new DestroyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game))), source);
        return true;
    }
}

