/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.mana.AddManaOfAnyColorEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class PulseOfLlanowarReplacementEffect
extends ReplacementEffectImpl {
    PulseOfLlanowarReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a basic land you control is tapped for mana, it produces mana of a color of your choice instead of any other type";
    }

    private PulseOfLlanowarReplacementEffect(PulseOfLlanowarReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PulseOfLlanowarReplacementEffect copy() {
        return new PulseOfLlanowarReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        new AddManaOfAnyColorEffect(mana.count()).apply(game, source);
        mana.setToMana(new Mana(0, 0, 0, 0, 0, 0, 0, 0));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game) && permanent.isBasic(game) && permanent.isControlledBy(source.getControllerId());
    }
}

