/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PulseOfTheFieldsReturnToHandEffect
extends OneShotEffect {
    PulseOfTheFieldsReturnToHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if an opponent has more life than you, return {this} to its owner's hand";
    }

    private PulseOfTheFieldsReturnToHandEffect(PulseOfTheFieldsReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public PulseOfTheFieldsReturnToHandEffect copy() {
        return new PulseOfTheFieldsReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || player.getLife() <= controller.getLife()) continue;
                Card card = game.getCard(source.getSourceId());
                controller.moveCards(card, Zone.HAND, source, game);
                return true;
            }
        }
        return false;
    }
}

