/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PuppetMasterEffect
extends OneShotEffect {
    PuppetMasterEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return that card to its owner's hand. If that card is returned to its owner's hand this way, you may pay {U}{U}{U}. If you do, return {this} to its owner's hand";
    }

    private PuppetMasterEffect(PuppetMasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public PuppetMasterEffect copy() {
        return new PuppetMasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("attachedTo");
        if (controller == null || permanent == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        if (card == null || card.getZoneChangeCounter(game) != permanent.getZoneChangeCounter(game) + 1) {
            return false;
        }
        controller.moveCards(card, Zone.HAND, source, game);
        if (game.getState().getZone(card.getId()) != Zone.HAND) {
            return false;
        }
        card = game.getCard(source.getSourceId());
        if (card == null || card.getZoneChangeCounter(game) != source.getStackMomentSourceZCC() + 1) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{U}{U}{U}");
        if (!controller.chooseUse(Outcome.Neutral, "Pay " + cost.getText() + " to return " + card.getLogName() + " to its owner's hand?", source, game) || !cost.pay(source, game, source, controller.getId(), false, null)) {
            return true;
        }
        controller.moveCards(card, Zone.HAND, source, game);
        return true;
    }
}

