/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PurifyingDragonEffect
extends OneShotEffect {
    PurifyingDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 1 damage to target creature defending player controls. If that creature is a Zombie, {this} deals 2 damage to it instead";
    }

    private PurifyingDragonEffect(PurifyingDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public PurifyingDragonEffect copy() {
        return new PurifyingDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return permanent.damage(permanent.hasSubtype(SubType.ZOMBIE, game) ? 2 : 1, source.getSourceId(), source, game) > 0;
    }
}

