/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class PursuitOfKnowledgeEffect
extends ReplacementEffectImpl {
    PursuitOfKnowledgeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, you may put a study counter on {this} instead";
    }

    private PursuitOfKnowledgeEffect(PursuitOfKnowledgeEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PursuitOfKnowledgeEffect copy() {
        return new PursuitOfKnowledgeEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller != null && controller.chooseUse(Outcome.Benefit, "Add a study counter instead of drawing a card?", source, game)) {
            new AddCountersSourceEffect(CounterType.STUDY.createInstance()).apply(game, source);
            return true;
        }
        return false;
    }
}

