/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PutridCyclopEffect
extends OneShotEffect {
    PutridCyclopEffect() {
        super(Outcome.Detriment);
        this.staticText = "scry 1, then reveal the top card of your library. {this} gets -X/-X until end of turn, where X is that card's mana value. <i>(To scry 1, look at the top card of your library, then you may put that card on the bottom of your library.)</i>";
    }

    private PutridCyclopEffect(PutridCyclopEffect effect) {
        super((OneShotEffect)effect);
    }

    public PutridCyclopEffect copy() {
        return new PutridCyclopEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            new ScryEffect(1).apply(game, source);
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
                int unboost = card.getManaValue() * -1;
                BoostSourceEffect effect = new BoostSourceEffect(unboost, unboost, Duration.EndOfTurn);
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

