/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfMainPhaseDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TargetPlayerActivatesAllManaAbilitiesEffect;
import mage.abilities.effects.common.continuous.AssignNoCombatDamageSourceEffect;
import mage.abilities.effects.mana.AddManaToManaPoolSourceControllerEffect;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

class PygmyHippoEffect
extends OneShotEffect {
    PygmyHippoEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "you may have defending player activate a mana ability of each land they control and lose all unspent mana. If you do, {this} assigns no combat damage this turn and at the beginning of your next main phase this turn, you add an amount of {C} equal to the amount of mana that player lost this way";
    }

    private PygmyHippoEffect(PygmyHippoEffect effect) {
        super((OneShotEffect)effect);
    }

    public PygmyHippoEffect copy() {
        return new PygmyHippoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        new TargetPlayerActivatesAllManaAbilitiesEffect().setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        int amountToAdd = targetPlayer.getManaPool().count();
        targetPlayer.getManaPool().emptyPool(game);
        game.addEffect((ContinuousEffect)new AssignNoCombatDamageSourceEffect(Duration.EndOfTurn, true), source);
        if (amountToAdd > 0) {
            AtTheBeginOfMainPhaseDelayedTriggeredAbility delayed = new AtTheBeginOfMainPhaseDelayedTriggeredAbility((Effect)new AddManaToManaPoolSourceControllerEffect(new Mana(ManaType.COLORLESS, amountToAdd)), false, TargetController.YOU, AtTheBeginOfMainPhaseDelayedTriggeredAbility.PhaseSelection.NEXT_MAIN_THIS_TURN);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayed, source);
        }
        return true;
    }
}

