/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PyreticRebirthTargetEffect
extends OneShotEffect {
    PyreticRebirthTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target artifact or creature card from your graveyard to your hand. {this} deals damage equal to that card's mana value to up to one target creature or planeswalker";
    }

    private PyreticRebirthTargetEffect(PyreticRebirthTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public PyreticRebirthTargetEffect copy() {
        return new PyreticRebirthTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        int mv = card.getManaValue();
        List targets = this.getTargetPointer().getTargets(game, source);
        boolean result = new ReturnFromGraveyardToHandTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game)).apply(game, source);
        if (targets.size() >= 2) {
            result |= new DamageTargetEffect(mv).setTargetPointer((TargetPointer)new FixedTarget((UUID)targets.get(1), game)).apply(game, source);
        }
        return result;
    }
}

