/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PyrogoyfEffect
extends OneShotEffect {
    PyrogoyfEffect() {
        super(Outcome.Damage);
        this.staticText = "that creature deals damage equal to its power to any target";
    }

    private PyrogoyfEffect(PyrogoyfEffect effect) {
        super((OneShotEffect)effect);
    }

    public PyrogoyfEffect copy() {
        return new PyrogoyfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent damagingPermanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (damagingPermanent == null) {
            return false;
        }
        int damageValue = damagingPermanent.getPower().getValue();
        Permanent anotherPermanent = game.getPermanent(source.getFirstTarget());
        Player anotherPlayer = game.getPlayer(source.getFirstTarget());
        if (anotherPermanent != null) {
            anotherPermanent.damage(damageValue, damagingPermanent.getId(), source, game);
            return true;
        }
        if (anotherPlayer != null) {
            anotherPlayer.damage(damageValue, damagingPermanent.getId(), source, game);
            return true;
        }
        return false;
    }
}

