/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PyromancerAscensionCopyTriggeredAbility
extends TriggeredAbilityImpl {
    PyromancerAscensionCopyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyTargetStackObjectEffect(true), true);
    }

    private PyromancerAscensionCopyTriggeredAbility(PyromancerAscensionCopyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PyromancerAscensionCopyTriggeredAbility copy() {
        return new PyromancerAscensionCopyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        Spell spell;
        if (event.getPlayerId().equals(this.getControllerId()) && this.isControlledInstantOrSorcery(spell = game.getStack().getSpell(event.getTargetId()), game) && (permanent = game.getPermanent(this.getSourceId())) != null && permanent.getCounters(game).getCount(CounterType.QUEST) >= 2) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            return true;
        }
        return false;
    }

    private boolean isControlledInstantOrSorcery(Spell spell, Game game) {
        return spell != null && spell.isControlledBy(this.getControllerId()) && spell.isInstantOrSorcery(game);
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell while {this} has two or more quest counters on it, you may copy that spell. You may choose new targets for the copy.";
    }
}

