/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PyrotechnicPerformerEffect
extends OneShotEffect {
    PyrotechnicPerformerEffect() {
        super(Outcome.Damage);
        this.staticText = "that creature deals damage equal to its power to each opponent";
    }

    private PyrotechnicPerformerEffect(PyrotechnicPerformerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent turnedUpCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (turnedUpCreature == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            opponent.damage(turnedUpCreature.getPower().getValue(), turnedUpCreature.getId(), source, game);
        }
        return true;
    }

    public PyrotechnicPerformerEffect copy() {
        return new PyrotechnicPerformerEffect(this);
    }
}

