/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.TargetPlayerShufflesTargetCardsEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.TargetSpell;
import mage.target.common.TargetCardInTargetPlayersGraveyard;
import mage.target.common.TargetCreatureOrPlaneswalker;
import mage.target.common.TargetCreaturePermanent;

public final class QuandrixCommand
extends CardImpl {
    private static final FilterSpell filter = new FilterSpell("artifact or enchantment spell");

    public QuandrixCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{G}{U}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetCreatureOrPlaneswalker());
        Mode mode = new Mode((Effect)new CounterTargetEffect());
        mode.addTarget((Target)new TargetSpell(filter));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(2)));
        mode.addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new TargetPlayerShufflesTargetCardsEffect());
        mode.addTarget((Target)new TargetPlayer());
        mode.addTarget((Target)new TargetCardInTargetPlayersGraveyard(3));
        this.getSpellAbility().addMode(mode);
    }

    private QuandrixCommand(QuandrixCommand card) {
        super((CardImpl)card);
    }

    public QuandrixCommand copy() {
        return new QuandrixCommand(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

