/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class QuarryColossusReturnLibraryEffect
extends OneShotEffect {
    QuarryColossusReturnLibraryEffect() {
        super(Outcome.Detriment);
        this.staticText = "put target creature into its owner's library just beneath the top X cards of that library, where X is the number of Plains you control";
    }

    private QuarryColossusReturnLibraryEffect(QuarryColossusReturnLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuarryColossusReturnLibraryEffect copy() {
        return new QuarryColossusReturnLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player owner;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && controller != null && (owner = game.getPlayer(permanent.getOwnerId())) != null) {
            int plains = game.getBattlefield().countAll(new FilterPermanent(SubType.PLAINS, "Plains you control"), source.getControllerId(), game);
            controller.putCardOnTopXOfLibrary((Card)permanent, game, source, plains + 1, true);
            return true;
        }
        return false;
    }
}

