/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.TargetCard;

class QueenKaylaBinKroogTarget
extends TargetCard {
    private static final FilterCard filter = new FilterCard("artifact or creature card");

    QueenKaylaBinKroogTarget() {
        super(0, 3, Zone.ALL, filter);
        this.withNotTarget(true);
    }

    private QueenKaylaBinKroogTarget(QueenKaylaBinKroogTarget target) {
        super((TargetCard)target);
    }

    public QueenKaylaBinKroogTarget copy() {
        return new QueenKaylaBinKroogTarget(this);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Set usedManaValues = this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(MageObject::getManaValue).collect(Collectors.toSet());
        possibleTargets.removeIf(uuid -> {
            Card card = game.getCard(uuid);
            return card == null || usedManaValues.contains(card.getManaValue());
        });
        return possibleTargets;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

