/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class QuestForAncientSecretsEffect
extends OneShotEffect {
    QuestForAncientSecretsEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target player shuffles their graveyard into their library";
    }

    private QuestForAncientSecretsEffect(QuestForAncientSecretsEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuestForAncientSecretsEffect copy() {
        return new QuestForAncientSecretsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        player.putCardsOnBottomOfLibrary((Cards)player.getGraveyard(), game, source, false);
        player.shuffleLibrary(source, game);
        return true;
    }
}

