/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Iterator;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class QuestForTheNihilStoneTriggeredAbility
extends TriggeredAbilityImpl {
    public QuestForTheNihilStoneTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(5), true);
    }

    private QuestForTheNihilStoneTriggeredAbility(QuestForTheNihilStoneTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public QuestForTheNihilStoneTriggeredAbility copy() {
        return new QuestForTheNihilStoneTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Iterator iterator;
        Player opponent;
        Permanent quest = game.getPermanent(super.getSourceId());
        if (quest == null) {
            Permanent questLKI;
            quest = questLKI = (Permanent)game.getLastKnownInformation(super.getSourceId(), Zone.BATTLEFIELD);
        }
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (opponent = game.getPlayer(event.getPlayerId())) != null && opponent.getHand().isEmpty() && quest.getCounters(game).getCount(CounterType.QUEST) >= 2 && (iterator = this.getEffects().iterator()).hasNext()) {
            Effect effect = (Effect)iterator.next();
            effect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "At the beginning of each opponent's upkeep, if that player has no cards in hand and {this} has two or more quest counters on it, you may have that player lose 5 life.";
    }
}

