/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.permanent.Permanent;

class QuestingBeastPreventionEffect
extends ContinuousRuleModifyingEffectImpl {
    QuestingBeastPreventionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Combat damage that would be dealt by creatures you control can't be prevented";
    }

    private QuestingBeastPreventionEffect(QuestingBeastPreventionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public QuestingBeastPreventionEffect copy() {
        return new QuestingBeastPreventionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PREVENT_DAMAGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!((PreventDamageEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId());
    }
}

