/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.RemoveCounterCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class QuilledGreatwurmEffect
extends AsThoughEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    QuilledGreatwurmEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "you may cast this card from your graveyard by removing six counters from among creatures you control in addition to paying its other costs";
    }

    private QuilledGreatwurmEffect(QuilledGreatwurmEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public QuilledGreatwurmEffect copy() {
        return new QuilledGreatwurmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectControllerId, Game game) {
        if (!source.getSourceId().equals(objectId) || !source.isControlledBy(affectControllerId) || game.getState().getZone(objectId) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(affectControllerId);
        if (controller == null) {
            return false;
        }
        CostsImpl costs = new CostsImpl();
        costs.add((Object)new RemoveCounterCost((Target)new TargetControlledPermanent(1, 6, (FilterControlledPermanent)filter, true), null, 6));
        controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{4}{G}{G}"), (Costs)costs, MageIdentifier.QuilledGreatwurmAlternateCast);
        return true;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

