/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.FrogGreenToken;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

class QuinaQuGourmetEffect
extends ReplacementEffectImpl {
    QuinaQuGourmetEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if one or more tokens would be created under your control, those tokens plus a 1/1 green Frog creature token are created instead";
    }

    private QuinaQuGourmetEffect(QuinaQuGourmetEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public QuinaQuGourmetEffect copy() {
        return new QuinaQuGourmetEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Map tokens = ((CreateTokenEvent)event).getTokens();
        Token token = (Token)CardUtil.castStream(tokens.values(), FrogGreenToken.class).findAny().orElseGet(FrogGreenToken::new);
        tokens.compute(token, CardUtil::setOrIncrementValue);
        return false;
    }
}

