/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Collection;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class QuintoriusKandEffect
extends OneShotEffect {
    QuintoriusKandEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of target cards from your graveyard. Add {R} for each card exiled this way. You may play those cards this turn";
    }

    private QuintoriusKandEffect(QuintoriusKandEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuintoriusKandEffect copy() {
        return new QuintoriusKandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.getManaPool().addMana(Mana.RedMana((int)cards.size()), game, source);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }
}

