/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AlluringEyesDrawEffect
extends OneShotEffect {
    AlluringEyesDrawEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player draws a card";
    }

    private AlluringEyesDrawEffect(AlluringEyesDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.drawCards(1, source, game);
        }
        return true;
    }

    public AlluringEyesDrawEffect copy() {
        return new AlluringEyesDrawEffect(this);
    }
}

