/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class FallEffect
extends OneShotEffect {
    FallEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals two cards at random from their hand, then discards each nonland card revealed this way";
    }

    private FallEffect(FallEffect effect) {
        super((OneShotEffect)effect);
    }

    public FallEffect copy() {
        return new FallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null) {
            return false;
        }
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return true;
        }
        if (targetPlayer.getHand().isEmpty()) {
            return true;
        }
        Card card = targetPlayer.getHand().getRandom(game);
        if (card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(card);
        if (targetPlayer.getHand().size() > 1) {
            do {
                if ((card = targetPlayer.getHand().getRandom(game)) != null) continue;
                return false;
            } while (cards.contains((Object)card.getId()));
            cards.add(card);
        }
        targetPlayer.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        targetPlayer.discard((Cards)new CardsImpl(cards.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game)), false, source, game);
        return true;
    }
}

