/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.r.RadiantScrollwielderReplacementEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class RadiantScrollwielderEffect
extends OneShotEffect {
    RadiantScrollwielderEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile an instant or sorcery card at random from your graveyard. You may cast it this turn. If a spell cast this way would be put into your graveyard, exile it instead";
    }

    private RadiantScrollwielderEffect(RadiantScrollwielderEffect effect) {
        super((OneShotEffect)effect);
    }

    public RadiantScrollwielderEffect copy() {
        return new RadiantScrollwielderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        target.withNotTarget(true);
        target.setRandom(true);
        target.chooseTarget(this.outcome, player.getId(), source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)card, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)false, (boolean)false, (boolean)true);
        game.addEffect((ContinuousEffect)new RadiantScrollwielderReplacementEffect(card, game), source);
        return true;
    }
}

