/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.effects.common.CopySpellForEachItCouldTargetEffect;
import mage.filter.StaticFilters;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;

class RadiateEffect
extends CopySpellForEachItCouldTargetEffect {
    RadiateEffect() {
        this.staticText = "Choose target instant or sorcery spell that targets only a single permanent or player. Copy that spell for each other permanent or player the spell could target. Each copy targets a different one of those permanents and players.";
    }

    private RadiateEffect(RadiateEffect effect) {
        super((CopySpellForEachItCouldTargetEffect)effect);
    }

    protected Player getPlayer(Game game, Ability source) {
        return game.getPlayer(source.getControllerId());
    }

    protected List<MageObjectReferencePredicate> prepareCopiesWithTargets(StackObject stackObject, Player player, Ability source, Game game) {
        ArrayList<MageObjectReferencePredicate> predicates = new ArrayList<MageObjectReferencePredicate>();
        UUID ignoreTargeted = ((Spell)stackObject).getSpellAbilities().stream().map(AbilityImpl::getTargets).flatMap(Collection::stream).map(Target::getTargets).flatMap(Collection::stream).filter(Objects::nonNull).findAny().orElse(null);
        game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT, player.getId(), source, game).stream().filter(Objects::nonNull).filter(p -> !p.equals(game.getPermanent(ignoreTargeted))).filter(p -> stackObject.canTarget(game, p.getId())).map(p -> new MageObjectReference((MageObject)p, game)).map(MageObjectReferencePredicate::new).forEach(predicates::add);
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().filter(uuid -> !uuid.equals(ignoreTargeted)).filter(uuid -> stackObject.canTarget(game, uuid)).map(MageObjectReference::new).map(MageObjectReferencePredicate::new).forEach(predicates::add);
        return predicates;
    }

    protected Spell getStackObject(Game game, Ability source) {
        return game.getSpell(source.getFirstTarget());
    }

    public RadiateEffect copy() {
        return new RadiateEffect(this);
    }
}

